my %handlers = (
  'width' => sub {
    my ($self, $value) = @_;
    if ($value) {
      $value = 12 if $value < 12;
      $value = 400 if $value > 400;
      $self->connection->pref(scr_width => $value);
      $self->send("Your screen width is now $value.\n");
    } else {
      $self->send("Your screen width is @{[$self->connection->scr_width]}.\n");
    }  
  },
  'height' => sub {
    my ($self, $value) = @_;
    if ($value) {
      $value = 4 if $value < 4;
      $value = 2000 if $value > 2000;
      $self->connection->pref(scr_height => $value);
      $self->send("Your screen height is now $value.\n");
    } else {
      $self->send("Your screen height is @{[$self->connection->scr_height]}.\n");
    }  
  },
  'color' => sub {
    my ($self, $value) = @_;
    my $t;
    if ($value) {
      $t = 1 if $value =~ /on|1|true|yes|complete/;
      $t = 0 if $value =~ /off|0|false|no/;
    }
    if (defined $t) {
      $self->connection->pref(color => $t);
      $self->send("Color is now @{[$t ? 'on' : 'off']}.\n");
    } else {
      $self->send(qq{Color is @{[$self->connection->pref('color') ? 'on' : 'off']}.\n});
    }
  },
  'brief' => sub {
    my ($self, $value) = @_;
    my $t;
    if ($value) {
      $t = 1 if $value =~ /on|1|true|yes/;
      $t = 0 if $value =~ /off|0|false|no/;
    }
    if (defined $t) {
      $self->connection->pref(brief => $t);
      $self->send("Brief-look mode is now @{[$t ? 'on' : 'off']}.\n");
    } else {
      $self->send(qq{Brief-look mode is @{[$self->connection->pref('brief') ? 'on' : 'off']}.\n});
    }
  },
  'prompt' => sub {
    my ($self, $value) = @_;
    my $t;
    if ($value) {
      $t = 1 if $value =~ /on|1|true|yes/;
      $t = 0 if $value =~ /off|0|false|no/;
    }
    if (defined $t) {
      $self->connection->pref(prompts => $t);
      $self->send("Prompts are now @{[$t ? 'on' : 'off']}.\n");
    } else {
      $self->send(qq{Prompts are @{[$self->connection->pref('prompts') ? 'on' : 'off']}.\n});
    }
  },
  'combine' => sub {
    my ($self, $value) = @_;
    my $t;
    if ($value) {
      $t = 1 if $value =~ /on|1|true|yes/;
      $t = 0 if $value =~ /off|0|false|no/;
    }
    if (defined $t) {
      $self->connection->pref(combine_output => $t);
      $self->send("Duplicate output will@{[$t ? '' : ' not']} be combined.\n");
    } else {
      $self->send("Duplicate output is@{[$t ? '' : ' not']} being combined.\n");
    }
  },
);

my $get_cmd_help = sub {
  my ($cmd) = @_;
  my $buf = "&c;- Command '$cmd'&n;\n";
  my $aka = join ', ', $self->cmdi_aliases($cmd);
  $buf .= "&c;Also known as: $aka&n;\n" if $aka;
  if ($self->priv_watcher) {
    $buf .= "&c;Requires: " . (join ', ', $self->cmdi_requires($cmd)) . "&n;\n";
  }      
  $buf .= $self->cmdi_help($cmd) || 'No help is available for this command.';
  return $buf;
};

MObject->Commands (
#---------------------------------------------------------------------------------------------------
  cpref => {code => sub {
    my ($self, $args) = @_;
    my ($field, $value) = split /\s+/, $args;

    if (!$field) {
      $self->send("Connection preferences:");
      foreach (keys %handlers) {
        $self->connection->send_str("($_) "); # ugly
        $handlers{$_}->($self);
      }
      return;
    } else {
      ($handlers{$field} || sub {$self->send("Sorry, I don't know what that is.")})->($self, $value);
    }
  }, help => <<'EOHELP'},
cpref [ width | height | color | brief | prompt | combine ] [&g<value>&n]

For viewing and setting connection options. Use "&y;cpref <field>&n" to see the current value, "&y;cpref <field> <value>&n" to change it, or "&y;cpref&n;" by itself to see all preferences.

Values are:
  &y;width&n; (number): Terminal width
  &y;height&n; (number): Terminal height
  &y;color&n; (toggle): Color on
  &y;brief&n; (toggle): Brief mode - moving into a room will not display its description.
  &y;prompt&n; (toggle): Display a prompt.
  &y;combine&n; (toggle): Combines duplicate output lines. Turning this on may slow down the server.
EOHELP
#---------------------------------------------------------------------------------------------------
  who => {code => sub {
    my ($self, $args) = @_;

    my $buf = '';
    $buf .= "&:c;Players currently connected:&:n;\n";
    foreach (sort {$b->id <=> $a->id} values %MConnection::Connections) {
      my $po = $_->object;
      next unless $po;
      my @priv = map ucfirst((/^priv_(.*)$/)[0]), grep /^priv_/, $po->fields;
      @priv = grep $_ ne 'Watcher', @priv if @priv > 2;
      local $" = ', ';
      $buf .= sprintf " %s%s%s&:n;%s\n", ($po == $self ? '>' : ' '), $po->name, $po->title, (@priv ? " (@priv)" : "");
    }
    $self->send_page($buf);
  }},
#---------------------------------------------------------------------------------------------------
  help => {code => sub {
    my ($self, $args) = @_;

    if ($args eq '-r') {
      MHelp->load_help;
      $self->send("Done.");

    } elsif ($args =~ /:/) {
      my ($cat, $key) = split /\s*:\s*/, $args, 2;
      $self->send_page(MHelp->hf_text($cat, $key, $self) || "There is no such help file.");

    } elsif ($args eq '') {
      $self->send_page(MHelp->hf_text('info', 'basic', $self) || 'Error: missing root help file');
      
    } elsif (my @r = MHelp->search($args, $self)) {
      if (@r > 1) {
        my $buf = "More than one help entry matched your keyword. Please choose one:\n";
        $buf .= join "\n", map "  help $$_[0]:$$_[1]", @r;
        $self->send_page($buf, name => "Help Search '$args'");
      } else {
        $self->send_page(MHelp->hf_text(@{$r[0]}, $self), name => "help $r[0][0]:$r[0][1]");
      }
      
    } else {
      $self->send("No help entry for '$args'.\nYour keyword has been logged.");
      mudlog "KEYWORD: help '$args'";
    }
  }},
#---------------------------------------------------------------------------------------------------
commands => {
  code => sub {
    my ($self, $args) = @_;
    
    my $alt = $args =~ s/-a//;
    
    $self->send("The commands available to you are:");
    if (my $sort = $args =~ s/-s//) {
      $self->send_multicol(
        sort {    ($a =~ /^(?:&.*?;)?(.*?)(?:&.*?;)?$/)[0]
              cmp ($b =~ /^(?:&.*?;)?(.*?)(?:&.*?;)?$/)[0]} map {
          ($self->cmdi_requires($_) ? "&:c;$_&:n;" : $_),
          (map "&:b;$_&:n;", $self->cmdi_aliases($_))
        }
        $self->commands_for_display
      );
    } else {
      $self->send_multicol(
        map {
          ($self->cmdi_requires($_) ? "&:c;$_&:n;" : $_),
          ($alt ? (map "  $_", $self->cmdi_aliases($_)) : ())
        }
        $self->commands_for_display
      );
    }
  },
},
#---------------------------------------------------------------------------------------------------
socials => {
  code => sub {
    my ($self, $args) = @_;
    
    if ($args eq '-r') {
      MSocials->load;
      $self->send("Done.");
    }
    
    $self->send("The social commands are:");
    $self->send_multicol(sort MSocials->all);
  },
},
#---------------------------------------------------------------------------------------------------
  title => {
    code => sub {
      my ($self, $args) = @_;
      $args = " $args" if $args =~ /^\w/;
      $self->title($args);
      $self->send("Okay, you're now " . $self->name . $self->title . ".\n");
    },
  },
#---------------------------------------------------------------------------------------------------
  report => {code => sub {
    my ($self, $args) = @_;
    
    my ($type, $str) = split /\s+/, $args, 2;
    $type or do {
      $self->send("What do you want to report?");
      return;
    };
    $type =~ /^(bug|idea|typo|note|gripe)$/i or do {
      $self->send("You must specify a report type of bug, idea, typo, note, or gripe.");
      return;
    };
    mudlog uc($type) . " REPORT: " . $self->name . " at " . $self->container->name . "#" . $self->container->id . ": $str";
  }, help => <<'EOHELP'},
report bug|idea|typo|note|gripe &:g;<message>&:n;

This command is used to report problems and ideas to the administration. Your &:g;<message>&:n; is logged, together with the room which you are in.

If you're not sure what type of report you have, use these examples as a guideline:
  bug - "Hey! All my items are gone!"
  idea - "It would be cool if..."
  typo - "These room descriptions are awful!"
  note - "Is this spell really supposed to work better indoors?"
  gripe - "Armor gets damaged way too fast."
EOHELP
#---------------------------------------------------------------------------------------------------
  think => {code => sub {$_[0]->send($_[1])}},
#---------------------------------------------------------------------------------------------------
  alias => {code => sub {$_[0]->connection->do_alias_cmd($_[1])}, help => <<'EOHELP'},
alias
alias <word> <commands>
alias <word>

Aliases allow you to substitute short commands for long ones, e.g. "kw" becomes "kill wolf".

You can make use of arguments to the alias by the replacements '$0' through '$9'. $0 is the entire argument string, and $1-$9 are individual words. You can also use $*&:c;<n>&:n; to get all the words from &:c;<n>&:n; to the end of the line, where &:c;<n>&:n; is a number from 1 to 9.

Examples:

> &:y;alias bsay emote says boredly, '$0'&:n
Set alias.
> &:y;bsay So what?&:n
Marn says boredly, 'So what?'
EOHELP
#---------------------------------------------------------------------------------------------------
review => { code => sub {
  my ($self, $args) = @_;

  my $obj = $self->object_find($args);
  my $con = $obj->connection or die "CFAIL:@{[$obj->nphr]} has no log to review.";
  $con->can('captured') or die "CFAIL:@{[$obj->nphr]} has no log to review.";
  $self->send_page($con->captured, name => "Log of @{[$obj->nphr]}");
}},
#---------------------------------------------------------------------------------------------------
);

MObject->CommandAliases (
  cpref => [qw(config toggles)],
);

MObject->Fields (
  title => {default => ''},
);
